extends CharacterBody2D

const SPEED = 400.0
const JUMP_VELOCITY = -700.0

# ### ALTERAÇÃO 1: Defini o limite de altura para a queda ###
# Ajuste o valor "2000" conforme a profundidade do seu mapa.
const LIMITE_QUEDA = 2000.0

# Get the gravity from the project settings to be synced with RigidBody nodes.
var gravity = ProjectSettings.get_setting("physics/2d/default_gravity")
@onready var sprite_2d = $Sprite2D

# ### NOVA ALTERAÇÃO: Variável para salvar o ponto de retorno ###
# Criamos uma variável para guardar as coordenadas (X, Y) iniciais.
var posicao_inicial = Vector2.ZERO

func _ready():
	# ### NOVA ALTERAÇÃO: Guardar a posição ao iniciar ###
	# A função _ready roda uma vez quando o personagem entra na cena.
	# Aqui salvamos onde ele está agora para usar depois.
	posicao_inicial = position

func _physics_process(delta):
	
	# ### ALTERAÇÃO 2 (ATUALIZADA): Lógica de TELETRANSPORTE ao cair ###
	# Se a posição Y do personagem for maior que o limite (caiu no buraco)
	if position.y > LIMITE_QUEDA:
		# Em vez de reload_current_scene(), jogamos o player para a posição salva
		position = posicao_inicial
		# IMPORTANTE: Zeramos a velocidade para ele não chegar no spawn caindo rápido
		velocity = Vector2.ZERO
	
	
	if (velocity.x > 1 || velocity.x < -1):
		sprite_2d.animation = "run"
	else:
		sprite_2d.animation = "default"
		
	# Add the gravity.
	if not is_on_floor():
		velocity.y += gravity * delta
		sprite_2d.animation = "jump"

	# Handle jump.
	if Input.is_action_just_pressed("up") and is_on_floor():
		velocity.y = JUMP_VELOCITY

	# Get the input direction and handle the movement/deceleration.
	var direction = Input.get_axis("left", "right")
	if direction:
		velocity.x = direction * SPEED
	else:
		velocity.x = move_toward(velocity.x, 0, SPEED)

	move_and_slide()
	
	# ### ALTERAÇÃO 3: Melhoria na lógica de virar o Sprite (Flip) ###
	# O código original fazia o personagem virar para a direita sempre que parava.
	# Agora ele só muda o lado se houver movimento (direction != 0).
	if direction != 0:
		sprite_2d.flip_h = (direction < 0)
